/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.InputNamesManager;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.udf.UDFParameterItem;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class BlockListCellRenderer
extends DefaultListCellRenderer {
    private boolean fBlockNumberVisible;
    protected float fScale = 1.0f;
    private InputNamesManager fInputNamesManager;
    private CommentManager fCommentManager;

    public BlockListCellRenderer() {
    }

    public BlockListCellRenderer(boolean blockNumberVisible) {
        this.fBlockNumberVisible = blockNumberVisible;
    }

    public BlockListCellRenderer(boolean blockNumbersVisible, LogoDrawing drawing) {
        this(blockNumbersVisible);
        this.fInputNamesManager = drawing.getInputNamesManager();
        this.fCommentManager = drawing.getCommentManager();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.handleLableByValue(value);
        return this;
    }

    protected void handleLableByValue(Object value) {
        Block block = null;
        if (value instanceof Block) {
            block = (Block)value;
        } else if (value instanceof ParameterItem) {
            block = ((ParameterItem)value).getParameter().getBlock();
        } else {
            if (value != null) {
                this.setIcon(null);
                this.setText(value.toString());
                return;
            }
            this.setIcon(null);
            this.setText(null);
            return;
        }
        this.setIcon(this.scaleIcon(Global.getIcon(block.getIconName())));
        this.setText(this.getValueText(block, value));
    }

    protected String getValueText(Block block, Object value) {
        CommentParameter comment;
        String inputName;
        String text = block.getLocalizedName(this.fBlockNumberVisible);
        if (value instanceof UDFParameterItem) {
            text = text + " - " + ((ParameterItem)value).getIdentifier();
        }
        if (this.fInputNamesManager != null && (inputName = this.fInputNamesManager.getInputName(block.getNumberString())).length() > 0) {
            StringBuffer buffer = new StringBuffer(text);
            buffer.append(" - ").append(inputName);
            text = buffer.toString();
        }
        if (value instanceof ParameterItem) {
            this.setText(text + " - " + ((ParameterItem)value).getLocalisedName());
        } else {
            this.setText(text);
        }
        if (this.fCommentManager != null && (comment = this.fCommentManager.getCommentParameter(block)) != null) {
            String commentText = comment.getText();
            if (commentText != null) {
                this.setToolTipText(commentText);
            } else {
                this.setToolTipText("");
            }
        }
        return text;
    }

    protected Icon scaleIcon(ImageIcon orgIcon) {
        float scale = this.getScale();
        if (scale == 1.0f) {
            return orgIcon;
        }
        return new ImageIcon(orgIcon.getImage().getScaledInstance((int)((float)orgIcon.getIconWidth() * scale), (int)((float)orgIcon.getIconHeight() * scale), scale > 1.0f ? 2 : 4));
    }

    public boolean isBlockNumbersVisible() {
        return this.fBlockNumberVisible;
    }

    public void setBlockNumbersVisible(boolean fBlockNumbersVisible) {
        this.fBlockNumberVisible = fBlockNumbersVisible;
    }

    public float getScale() {
        return this.fScale;
    }

    public void setScale(float scale) {
        this.fScale = scale;
    }
}

